/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface CompositeRequest
 */
export interface CompositeRequest {
    /**
     * First person birth date/time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof CompositeRequest
     */
    dateTime1: string;
    /**
     * 
     * @type {Location}
     * @memberof CompositeRequest
     */
    location1: Location;
    /**
     * Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof CompositeRequest
     */
    dateTime2: string;
    /**
     * 
     * @type {Location}
     * @memberof CompositeRequest
     */
    location2: Location;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof CompositeRequest
     */
    houseSystem?: CompositeRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof CompositeRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof CompositeRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof CompositeRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof CompositeRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof CompositeRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const CompositeRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type CompositeRequestHouseSystemEnum = typeof CompositeRequestHouseSystemEnum[keyof typeof CompositeRequestHouseSystemEnum];


/**
 * Check if a given object implements the CompositeRequest interface.
 */
export function instanceOfCompositeRequest(value: object): value is CompositeRequest {
    if (!('dateTime1' in value) || value['dateTime1'] === undefined) return false;
    if (!('location1' in value) || value['location1'] === undefined) return false;
    if (!('dateTime2' in value) || value['dateTime2'] === undefined) return false;
    if (!('location2' in value) || value['location2'] === undefined) return false;
    return true;
}

export function CompositeRequestFromJSON(json: any): CompositeRequest {
    return CompositeRequestFromJSONTyped(json, false);
}

export function CompositeRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): CompositeRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'dateTime1': json['dateTime1'],
        'location1': LocationFromJSON(json['location1']),
        'dateTime2': json['dateTime2'],
        'location2': LocationFromJSON(json['location2']),
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function CompositeRequestToJSON(json: any): CompositeRequest {
    return CompositeRequestToJSONTyped(json, false);
}

export function CompositeRequestToJSONTyped(value?: CompositeRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'dateTime1': value['dateTime1'],
        'location1': LocationToJSON(value['location1']),
        'dateTime2': value['dateTime2'],
        'location2': LocationToJSON(value['location2']),
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

