/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface LunarReturnRequest
 */
export interface LunarReturnRequest {
    /**
     * Birth date and time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof LunarReturnRequest
     */
    birthDateTime: string;
    /**
     * 
     * @type {Location}
     * @memberof LunarReturnRequest
     */
    birthLocation: Location;
    /**
     * Date to find lunar return from (ISO 8601). Defaults to now.
     * @type {string}
     * @memberof LunarReturnRequest
     */
    returnDate?: string;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof LunarReturnRequest
     */
    houseSystem?: LunarReturnRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof LunarReturnRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof LunarReturnRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof LunarReturnRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof LunarReturnRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof LunarReturnRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const LunarReturnRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type LunarReturnRequestHouseSystemEnum = typeof LunarReturnRequestHouseSystemEnum[keyof typeof LunarReturnRequestHouseSystemEnum];


/**
 * Check if a given object implements the LunarReturnRequest interface.
 */
export function instanceOfLunarReturnRequest(value: object): value is LunarReturnRequest {
    if (!('birthDateTime' in value) || value['birthDateTime'] === undefined) return false;
    if (!('birthLocation' in value) || value['birthLocation'] === undefined) return false;
    return true;
}

export function LunarReturnRequestFromJSON(json: any): LunarReturnRequest {
    return LunarReturnRequestFromJSONTyped(json, false);
}

export function LunarReturnRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): LunarReturnRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'birthDateTime': json['birthDateTime'],
        'birthLocation': LocationFromJSON(json['birthLocation']),
        'returnDate': json['returnDate'] == null ? undefined : json['returnDate'],
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function LunarReturnRequestToJSON(json: any): LunarReturnRequest {
    return LunarReturnRequestToJSONTyped(json, false);
}

export function LunarReturnRequestToJSONTyped(value?: LunarReturnRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'birthDateTime': value['birthDateTime'],
        'birthLocation': LocationToJSON(value['birthLocation']),
        'returnDate': value['returnDate'],
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

