/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface NatalRequest
 */
export interface NatalRequest {
    /**
     * Birth date and time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof NatalRequest
     */
    dateTime: string;
    /**
     * 
     * @type {Location}
     * @memberof NatalRequest
     */
    location: Location;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof NatalRequest
     */
    houseSystem?: NatalRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof NatalRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof NatalRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof NatalRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string | null>}
     * @memberof NatalRequest
     */
    points?: Array<string | null>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof NatalRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const NatalRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type NatalRequestHouseSystemEnum = typeof NatalRequestHouseSystemEnum[keyof typeof NatalRequestHouseSystemEnum];


/**
 * Check if a given object implements the NatalRequest interface.
 */
export function instanceOfNatalRequest(value: object): value is NatalRequest {
    if (!('dateTime' in value) || value['dateTime'] === undefined) return false;
    if (!('location' in value) || value['location'] === undefined) return false;
    return true;
}

export function NatalRequestFromJSON(json: any): NatalRequest {
    return NatalRequestFromJSONTyped(json, false);
}

export function NatalRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): NatalRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'dateTime': json['dateTime'],
        'location': LocationFromJSON(json['location']),
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function NatalRequestToJSON(json: any): NatalRequest {
    return NatalRequestToJSONTyped(json, false);
}

export function NatalRequestToJSONTyped(value?: NatalRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'dateTime': value['dateTime'],
        'location': LocationToJSON(value['location']),
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

