/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface ProgressionsRequest
 */
export interface ProgressionsRequest {
    /**
     * Birth date and time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof ProgressionsRequest
     */
    birthDateTime: string;
    /**
     * 
     * @type {Location}
     * @memberof ProgressionsRequest
     */
    birthLocation: Location;
    /**
     * Target date for progression calculation in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof ProgressionsRequest
     */
    targetDate: string;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof ProgressionsRequest
     */
    houseSystem?: ProgressionsRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof ProgressionsRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof ProgressionsRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof ProgressionsRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof ProgressionsRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof ProgressionsRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const ProgressionsRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type ProgressionsRequestHouseSystemEnum = typeof ProgressionsRequestHouseSystemEnum[keyof typeof ProgressionsRequestHouseSystemEnum];


/**
 * Check if a given object implements the ProgressionsRequest interface.
 */
export function instanceOfProgressionsRequest(value: object): value is ProgressionsRequest {
    if (!('birthDateTime' in value) || value['birthDateTime'] === undefined) return false;
    if (!('birthLocation' in value) || value['birthLocation'] === undefined) return false;
    if (!('targetDate' in value) || value['targetDate'] === undefined) return false;
    return true;
}

export function ProgressionsRequestFromJSON(json: any): ProgressionsRequest {
    return ProgressionsRequestFromJSONTyped(json, false);
}

export function ProgressionsRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): ProgressionsRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'birthDateTime': json['birthDateTime'],
        'birthLocation': LocationFromJSON(json['birthLocation']),
        'targetDate': json['targetDate'],
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function ProgressionsRequestToJSON(json: any): ProgressionsRequest {
    return ProgressionsRequestToJSONTyped(json, false);
}

export function ProgressionsRequestToJSONTyped(value?: ProgressionsRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'birthDateTime': value['birthDateTime'],
        'birthLocation': LocationToJSON(value['birthLocation']),
        'targetDate': value['targetDate'],
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

