/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface SolarReturnRequest
 */
export interface SolarReturnRequest {
    /**
     * Birth date and time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof SolarReturnRequest
     */
    birthDateTime: string;
    /**
     * 
     * @type {Location}
     * @memberof SolarReturnRequest
     */
    birthLocation: Location;
    /**
     * Year for solar return calculation. Defaults to current year.
     * @type {number}
     * @memberof SolarReturnRequest
     */
    returnYear?: number;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof SolarReturnRequest
     */
    houseSystem?: SolarReturnRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof SolarReturnRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof SolarReturnRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof SolarReturnRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof SolarReturnRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof SolarReturnRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const SolarReturnRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type SolarReturnRequestHouseSystemEnum = typeof SolarReturnRequestHouseSystemEnum[keyof typeof SolarReturnRequestHouseSystemEnum];


/**
 * Check if a given object implements the SolarReturnRequest interface.
 */
export function instanceOfSolarReturnRequest(value: object): value is SolarReturnRequest {
    if (!('birthDateTime' in value) || value['birthDateTime'] === undefined) return false;
    if (!('birthLocation' in value) || value['birthLocation'] === undefined) return false;
    return true;
}

export function SolarReturnRequestFromJSON(json: any): SolarReturnRequest {
    return SolarReturnRequestFromJSONTyped(json, false);
}

export function SolarReturnRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SolarReturnRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'birthDateTime': json['birthDateTime'],
        'birthLocation': LocationFromJSON(json['birthLocation']),
        'returnYear': json['returnYear'] == null ? undefined : json['returnYear'],
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function SolarReturnRequestToJSON(json: any): SolarReturnRequest {
    return SolarReturnRequestToJSONTyped(json, false);
}

export function SolarReturnRequestToJSONTyped(value?: SolarReturnRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'birthDateTime': value['birthDateTime'],
        'birthLocation': LocationToJSON(value['birthLocation']),
        'returnYear': value['returnYear'],
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

