/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface SynastryRequest
 */
export interface SynastryRequest {
    /**
     * First person birth date/time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof SynastryRequest
     */
    dateTime1: string;
    /**
     * 
     * @type {Location}
     * @memberof SynastryRequest
     */
    location1: Location;
    /**
     * Second person birth date/time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof SynastryRequest
     */
    dateTime2: string;
    /**
     * 
     * @type {Location}
     * @memberof SynastryRequest
     */
    location2: Location;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof SynastryRequest
     */
    houseSystem?: SynastryRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof SynastryRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof SynastryRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof SynastryRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof SynastryRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof SynastryRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const SynastryRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type SynastryRequestHouseSystemEnum = typeof SynastryRequestHouseSystemEnum[keyof typeof SynastryRequestHouseSystemEnum];


/**
 * Check if a given object implements the SynastryRequest interface.
 */
export function instanceOfSynastryRequest(value: object): value is SynastryRequest {
    if (!('dateTime1' in value) || value['dateTime1'] === undefined) return false;
    if (!('location1' in value) || value['location1'] === undefined) return false;
    if (!('dateTime2' in value) || value['dateTime2'] === undefined) return false;
    if (!('location2' in value) || value['location2'] === undefined) return false;
    return true;
}

export function SynastryRequestFromJSON(json: any): SynastryRequest {
    return SynastryRequestFromJSONTyped(json, false);
}

export function SynastryRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SynastryRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'dateTime1': json['dateTime1'],
        'location1': LocationFromJSON(json['location1']),
        'dateTime2': json['dateTime2'],
        'location2': LocationFromJSON(json['location2']),
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function SynastryRequestToJSON(json: any): SynastryRequest {
    return SynastryRequestToJSONTyped(json, false);
}

export function SynastryRequestToJSONTyped(value?: SynastryRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'dateTime1': value['dateTime1'],
        'location1': LocationToJSON(value['location1']),
        'dateTime2': value['dateTime2'],
        'location2': LocationToJSON(value['location2']),
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

