/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Location } from './Location';
import {
    LocationFromJSON,
    LocationFromJSONTyped,
    LocationToJSON,
    LocationToJSONTyped,
} from './Location';

/**
 * 
 * @export
 * @interface TransitRequest
 */
export interface TransitRequest {
    /**
     * Birth date and time in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof TransitRequest
     */
    birthDate: string;
    /**
     * 
     * @type {Location}
     * @memberof TransitRequest
     */
    birthLocation: Location;
    /**
     * Transit period start date in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof TransitRequest
     */
    transitDateStart: string;
    /**
     * Transit period end date in YYYY-MM-DDTHH:mm format
     * @type {string}
     * @memberof TransitRequest
     */
    transitDateEnd: string;
    /**
     * 
     * @type {Location}
     * @memberof TransitRequest
     */
    transitLocation: Location;
    /**
     * House system for calculations (default: "placidus")
     * @type {string}
     * @memberof TransitRequest
     */
    houseSystem?: TransitRequestHouseSystemEnum;
    /**
     * Language code for text content
     * @type {string}
     * @memberof TransitRequest
     */
    language?: string;
    /**
     * Include interpretation text
     * @type {boolean}
     * @memberof TransitRequest
     */
    includeText?: boolean;
    /**
     * Include human-readable entity titles
     * @type {boolean}
     * @memberof TransitRequest
     */
    includeReadableEntities?: boolean;
    /**
     * Celestial points to calculate (e.g., ["sun", "moon", "mercury"]). Defaults to all major planets.
     * @type {Array<string>}
     * @memberof TransitRequest
     */
    points?: Array<string>;
    /**
     * Custom orb values per aspect type (e.g., { "conjunction": 8, "opposition": 6 })
     * @type {{ [key: string]: number; }}
     * @memberof TransitRequest
     */
    orbs?: { [key: string]: number; };
}


/**
 * @export
 */
export const TransitRequestHouseSystemEnum = {
    Placidus: 'placidus',
    Koch: 'koch',
    Equal: 'equal',
    Whole: 'whole',
    Campanus: 'campanus',
    Regiomontanus: 'regiomontanus',
    Porphyry: 'porphyry'
} as const;
export type TransitRequestHouseSystemEnum = typeof TransitRequestHouseSystemEnum[keyof typeof TransitRequestHouseSystemEnum];


/**
 * Check if a given object implements the TransitRequest interface.
 */
export function instanceOfTransitRequest(value: object): value is TransitRequest {
    if (!('birthDate' in value) || value['birthDate'] === undefined) return false;
    if (!('birthLocation' in value) || value['birthLocation'] === undefined) return false;
    if (!('transitDateStart' in value) || value['transitDateStart'] === undefined) return false;
    if (!('transitDateEnd' in value) || value['transitDateEnd'] === undefined) return false;
    if (!('transitLocation' in value) || value['transitLocation'] === undefined) return false;
    return true;
}

export function TransitRequestFromJSON(json: any): TransitRequest {
    return TransitRequestFromJSONTyped(json, false);
}

export function TransitRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'birthDate': json['birthDate'],
        'birthLocation': LocationFromJSON(json['birthLocation']),
        'transitDateStart': json['transitDateStart'],
        'transitDateEnd': json['transitDateEnd'],
        'transitLocation': LocationFromJSON(json['transitLocation']),
        'houseSystem': json['houseSystem'] == null ? undefined : json['houseSystem'],
        'language': json['language'] == null ? undefined : json['language'],
        'includeText': json['includeText'] == null ? undefined : json['includeText'],
        'includeReadableEntities': json['includeReadableEntities'] == null ? undefined : json['includeReadableEntities'],
        'points': json['points'] == null ? undefined : json['points'],
        'orbs': json['orbs'] == null ? undefined : json['orbs'],
    };
}

export function TransitRequestToJSON(json: any): TransitRequest {
    return TransitRequestToJSONTyped(json, false);
}

export function TransitRequestToJSONTyped(value?: TransitRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'birthDate': value['birthDate'],
        'birthLocation': LocationToJSON(value['birthLocation']),
        'transitDateStart': value['transitDateStart'],
        'transitDateEnd': value['transitDateEnd'],
        'transitLocation': LocationToJSON(value['transitLocation']),
        'houseSystem': value['houseSystem'],
        'language': value['language'],
        'includeText': value['includeText'],
        'includeReadableEntities': value['includeReadableEntities'],
        'points': value['points'],
        'orbs': value['orbs'],
    };
}

